package ga.view.appstate.roomplanner;

import ga.view.appstate.SceneState;
import ga.view.config.ViewSettings;
import ga.view.interfaces.MouseListener;

import java.util.logging.Logger;

import com.jme3.app.Application;
import com.jme3.app.state.AppStateManager;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.input.MouseInput;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.shape.Box;

/**
 * 
 * @deprecated This was a prototype and has never been finished.
 */
@Deprecated
public class RoomPlanner extends SceneState {

  // the logger for this class
  private static final Logger LOGGER = Logger.getLogger(RoomPlanner.class
      .getName());

  private final ViewSettings viewSettings;

  private MenuMouseListener doubleClickListener;

  private Node testNode;
  private Node plane;

  /**
   * 
   * @deprecated This was a prototype and has never been finished.
   */
  @Deprecated
  public RoomPlanner(final ViewSettings viewSettings) {
    this.viewSettings = viewSettings;
  }

  @Override
  public void initialize(final AppStateManager stateManager,
      final Application app) {
    super.initialize(stateManager, app);

    inputManager.setCursorVisible(false);
    org.lwjgl.input.Mouse.setGrabbed(false);

    viewPort.setBackgroundColor(ColorRGBA.White);

    cam.setLocation(new Vector3f(0f, 4.5f, 0f));
    cam.lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
    cam.setParallelProjection(true);

    inputManager.addMapping("mousemove", new MouseButtonTrigger(
        MouseInput.BUTTON_LEFT));

    doubleClickListener = new MenuMouseListener();
    inputManager.addListener(doubleClickListener, "mousemove");

    testNode = new Node("TestNode");

    Geometry geo = new Geometry("TEST", new Box(0.1f, 0.1f, 0.1f));
    final Material lineMaterial = assetManager
        .loadMaterial("Common/Materials/RedColor.j3m");
    geo.setMaterial(lineMaterial);

    testNode.attachChild(geo);
    rootNode.attachChild(testNode);

    plane = new Node("PlaneNode");
    geo = new Geometry("PLANE", new Box(100f, 0.0f, 100f));
    final Material planeMaterial = assetManager
        .loadMaterial("Common/Materials/WhiteColor.j3m");
    geo.setMaterial(planeMaterial);

    plane.attachChild(geo);
    rootNode.attachChild(plane);

  }

  private CollisionResults findPick(final Node node) {
    final Vector3f origin = cam.getWorldCoordinates(
        inputManager.getCursorPosition(), 0.0f);
    final Vector3f direction = cam.getWorldCoordinates(
        inputManager.getCursorPosition(), 0.3f);
    direction.subtractLocal(origin).normalizeLocal();

    final Ray ray = new Ray(origin, direction);
    final CollisionResults results = new CollisionResults();
    node.collideWith(ray, results);
    return results;
  }

  @Override
  public void stateDetached(final AppStateManager stateManager) {
    super.stateDetached(stateManager);
    doubleClickListener.setEnabled(false);
  }

  @Override
  public void stateAttached(final AppStateManager stateManager) {
    super.stateAttached(stateManager);
    if (doubleClickListener != null) {
      doubleClickListener.setEnabled(true);
    }
  }

  @Override
  public void update(final float tpf) {
    doubleClickListener.update(tpf);

    super.update(tpf);

  }

  private class MenuMouseListener extends MouseListener {
    private Vector3f lastLoc;

    @Override
    public void onAction(final String name, final boolean keyPressed,
        final boolean isDoubleClick, final float tpf) {
      if (!keyPressed) {
        final CollisionResults results = findPick(rootNode);

        final float x = inputManager.getCursorPosition().x;
        final float y = inputManager.getCursorPosition().y;

        final Vector3f origin = cam.getWorldCoordinates(
            inputManager.getCursorPosition(), 0.0f);

        System.err.println("mouse (" + x + "," + y + ")");

        System.err.println(origin);

      }
    }

    public void update(final float tpf) {

      final CollisionResults results = findPick(plane);
      final CollisionResult r = results.getClosestCollision();

      final Vector3f origin = r.getContactPoint();

      if (!origin.equals(lastLoc)) {

        lastLoc = origin;
        System.err.println(origin);

        testNode.setLocalTranslation(lastLoc);
      }

    }
  }

}
